 <?php

/**
 * Grankare Theme Options CSS
 */

require_once ( GRANKARE_ADDON_DIR . 'admin/extension/theme-options/class.options-style.php' );
$grankare_styles = new Grankare_Theme_Styles;

ob_start();

echo "\n/* Grankare Theme Options CSS */";

echo "\n/* General Styles */\n";

//site width
$site_width = $grankare_styles->grankare_dimension_settings( 'site-width', 'width' );
if( $site_width ){
	echo '@media (min-width: 1400px){
		.container, .container-lg, .container-md, .container-sm, .container-xl, .container-xxl {
			max-width: '. esc_attr( $site_width ) .';
		}
	}';
}

//primary color
$primary_color = $grankare_styles->grankare_get_option( 'primary-color' );
$rgb = $grankare_styles->grankare_hex2rgba( $primary_color, 'none' );

/*
 * Theme Color -> $primary-color
 * Secondary Color -> $secondary_color
 * Theme RGBA -> $rgb example -> echo 'body{ background: rgba('. esc_attr( $rgb ) .', 0.5); }';
 * Theme Secondary RGBA -> $rgb example -> echo 'body{ background: rgba('. esc_attr( $secondary_rgb ) .', 0.5); }';
 */

if( $primary_color ){
	echo '.primary-color, .theme-color, a:focus, a:hover, a:active {
		color: '. esc_attr( $primary_color ) .';
	}';
	echo '.primary-bg, .theme-bg {
		background-color: '. esc_attr( $primary_color ) .';
	}';
	echo '.service-style-classic-pro .post-details-outer:before {
		background: linear-gradient(to right, '. esc_attr( $primary_color ) .', 184 151 128 / 6%));
	}';
	echo '.border-shape-top:before, .border-shape-top-left:before {
		background: radial-gradient(at center center,#ffffff0d 0%, '. esc_attr( $primary_color ) .' 100%) !important;
	}';
	echo '.border-shape-top:after, .border-shape-top-left:after {
		background: linear-gradient(to top, '. esc_attr( $primary_color ) .' 0%, rgb(58 123 213 / 0%));
	}';	
	echo '.team-wrapper.team-style-default .team-inner:after {
		background: linear-gradient(to bottom, rgba('. esc_attr( $rgb ) .', 0.30), rgb(58 123 213 / 0%));
	}';
	echo '.service-style-default .service-inner:hover:before {
		background: linear-gradient(to left, '. esc_attr( $primary_color ) .', rgb(58 123 213 / 0%));
	}';
	echo '.section-title-wrapper span.elementor-divider-separator {
		border-image: linear-gradient(to right, '. esc_attr( $primary_color ) .', rgb(58 123 213 / 0%));
    	border-image-slice: 1;
	}';
	echo '.service-style-classic-pro .post-details-outer:before {
		background: linear-gradient(to right, '. esc_attr( $primary_color ) .', rgb(58 123 213 / 0%));
	}';
	echo '.rtl .section-title-wrapper span.elementor-divider-separator {
		border-image: linear-gradient(to left, '. esc_attr( $primary_color ) .', rgb(58 123 213 / 0%));
    	border-image-slice: 1;
	}';
	echo 'aside.footer-widget-2 h5:before, .widget .widgettitle:before,	.widget .widget-title:before, .widget-area-right .wp-block-group__inner-container h1:before, .widget-area-right .wp-block-group__inner-container h2:before, .widget-area-right .wp-block-group__inner-container h4:before, .widget-area-right .wp-block-group__inner-container h5:before, .widget-area-right .wp-block-group__inner-container h6:before, .widget-area-left .widget .widget-title:before {
		border-color: '. esc_attr( $primary_color ) .';
	}';
	
	echo '.calendar_wrap th, tfoot td, .elementor-widget-container.feature-box-wrapper.feature-box-classic:after,  ul[id^="nv-primary-navigation"] li.button.button-primary > a, .menu li.button.button-primary > a, span.animate-bubble-box:after, span.animate-bubble-box:before, .owl-dots button.owl-dot.active, .team-style-classic-pro .team-social-wrap ul.social-icons > li > a,
.pagination-single-inner > h6 > a span.arrow, ::selection,.owl-carousel .owl-nav button.owl-next, .owl-carousel .owl-nav button.owl-prev, .content-widgets .widget .menu-service-sidebar-menu-container ul > li.current-menu-item > a, .content-widgets .widget .menu-service-sidebar-menu-container ul > li > a:after, .grankare-masonry .top-meta-wrap .post-category, .comments-pagination.pagination .page-numbers.current, .blog-wrapper.blog-style-default .blog-inner .post-date a, .portfolio-meta ul.nav.social-icons > li > a:hover, span.cea-popup-modal-dismiss.ti-close, blockquote:after,
.wp-block-quote.is-large:after, .wp-block-quote.is-style-large:after, .wp-block-quote.is-style-large:not(.is-style-plain):after,.wp-block-quote.has-text-align-right:after, .wp-block-quote:after, nav.post-nav-links .post-page-numbers.current, blockquote cite::before, .single-post .comments-wrapper.section-inner input.submit,
.page .comments-wrapper.section-inner input.submit, .widget-area-right .widget p.wp-block-tag-cloud a.tag-cloud-link:hover, .widget .tagcloud > a:hover, .widget .tagcloud > a:focus, .widget .tagcloud > a:active, .section-title-wrapper.title-theme .title-wrap > *.sub-title:after, .team-style-default .team-inner .post-overlay-items > .team-social-wrap, .blog-wrapper.blog-style-default .blog-inner .post-date a, .cea-tab-elementor-widget.tab-style-2.cea-vertical-tab a.nav-item.nav-link:before, .portfolio-single .portfolio-video.post-video-wrap .video-play-icon, .portfolio-wrapper.portfolio-style-default .isotope-filter ul.nav li a:before, .isotope-filter ul.nav.m-auto.d-block li.active a, .call-us-team a.cea-button-link:hover, .call-us-team a.cea-button-link span.cea-button-num, .header-navbar .cea-button-link.elementor-size-sm.elementor-button, .header-sticky .header-navbar .cea-button-link.elementor-size-sm:hover .cea-button-icon, .content-widgets .widget .menu-service-sidebar-menu-container ul > li > a:hover, .team-wrapper.team-style-default .team-inner .social-icons > li > a, .elementor-widget-ceaposts .blog-style-classic-pro .blog-inner .post-date a, .widget-area-left .contact-widget-info > p > span.bi,
.widget-area-right .contact-widget-info > p > span.bi, .row.portfolio-details .col-sm-4 > .portfolio-meta span.portfolio-meta-icon, .portfolio-single .portfolio-sub-title, .testimonial-wrapper.testimonial-style-default .owl-item .testimonial-inner:hover:before, .feature-box-style-5 .feature-box-wrapper .fbox-number, .service-style-classic-pro .post-details-outer .service-icon-img-wrap, .text-left .feature-box-classic .feature-box-title:after, .section-title-wrapper .title-wrap > *.sub-title .subtitle-dots:before, .team-wrapper.team-style-default .team-designation:after, .timeline > li > .timeline-sep-title:after,
.single-cea-team .team-info > *.team-title span.team-designation:after, .widget-service-button a, .sidebar-broucher .icon-box a:hover, .portfolio-style-default .portfolio-inner .post-thumb:after, p.quote-author:after, .elementor-widget-ceaposts .blog-wrapper.blog-style-list .blog-inner .post-date a, .woocommerce ul.products li.product .button, .woocommerce ul.products li.product .onsale, .woocommerce span.onsale, .woocommerce div.product .woocommerce-tabs ul.tabs li.active a, .woocommerce div.product .woocommerce-tabs ul.tabs li:hover a, .woocommerce ul.products li.product .button, .testimonial-wrapper.testimonial-style-classic .testimonial-designation:before, .woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li span.current, .woocommerce button.button:disabled[disabled], .woocommerce div.product .woocommerce-tabs ul.tabs li a:hover, .woocommerce div.product .woocommerce-tabs ul.tabs li.active a, .woocommerce button.button, .woocommerce-page .woocommerce-info .button, .woocommerce-MyAccount-navigation > ul li a:hover, .woocommerce-account .woocommerce-MyAccount-navigation > ul li.is-active a,.content-widgets-wrapper .widget_nav_menu .menu-services-menu-container li.current-menu-item a:before, .content-widgets-wrapper .widget_nav_menu .menu-services-menu-container li:hover a:before  {
		background-color: '. esc_attr( $primary_color ) .';
	}';
	echo '.theme-color-bg, .icon-theme-color-bg, .flip-box-wrapper:hover .icon-theme-hcolor-bg, .contact-info-style-classic-pro .contact-info-title, .contact-info-wrapper.contact-info-style-classic:before, .testimonial-wrapper.testimonial-style-modern .testimonial-inner:after, .blog-wrapper.blog-style-modern .blog-inner .top-meta .post-category, .blog-wrapper .post-overlay-items .post-date a, .event-style-classic .top-meta .post-date, .blog-layouts-wrapper .post-overlay-items .post-date a, .portfolio-content-wrap .portfolio-title h3, .custom-post-nav  a,
	.service-style-classic .entry-title:after,.service-style-classic .entry-title:before,.team-style-default .team-inner .post-overlay-items > .team-social-wrap > ul,
.team-style-default .team-inner:hover .post-overlay-items > .team-social-wrap,.back-to-top:after,
.portfolio-style-classic .post-thumb.post-overlay-active:after, .elementor-widget-container.feature-box-wrapper.feature-box-classic:after, h2.we-stand__top-title, span.zozo-product-favoured {
		background-color: '. esc_attr( $primary_color ) .' !important;
	}';
	echo '.full-search-wrapper .search-form .input-group .btn:hover, .testimonial-style-list .testimonial-inner:after,.team-details-icon,ul.nav.post-meta > li span,
.comment-metadata time, .comments-wrap span:before, .comment-body .reply a.comment-reply-link, .blog .grankare-masonry .post-meta .post-more a, .grankare-masonry .bottom-meta-wrap .post-meta .post-more a:hover .widget.widget_nav_menu li a:before, .grankare-masonry > article .top-meta-wrap a, h2.entry-title a:hover, .woocommerce-message::before, .woocommerce div.product .woocommerce-tabs ul.tabs li a:hover, .woocommerce div.product .woocommerce-tabs ul.tabs li.active a,
.woocommerce div.product p.price, .woocommerce div.product span.price,ul.pricing-features-list.list-group li:before, .doc-icon, p.quote-author, .feature-box-wrapper .fbox-content a:hover, ul.nav.post-meta > li.post-tag > a:hover, blockquote cite, .wp-block-quote cite, .wp-block-quote footer, .bottom-meta-wrap ul.nav.post-meta > li.post-date a:hover,
.single-post .top-meta-wrap ul.nav.post-meta li a:hover, .cus-img-menu .menu-item .widget .wp-block-image:hover figcaption a, .single-post blockquote cite, .single-post blockquote cite a, .content-widgets-wrapper .widget_categories ul li a:before, .content-widgets-wrapper .widget_archive ul li a:before, .content-widgets-wrapper .wp-block-categories li a:before, footer button.input-group-addon.zozo-mc.btn.btn-default, .cus-contact a:first-child, .pagination-single-inner > h6 > a:hover span.title, .grankare-masonry .bottom-meta-wrap .post-meta li.post-share-wrap .social-share a:hover i, .post-share-wrap ul.social-share > li > a:hover > i, .pricing-style-classic.pricing-table-wrapper ul > li:after, .widget-content-bx a i, .elementor-widget-ceaposts .blog-inner .read-more:hover:after, .widget-area-left .contact-widget-info > p a:hover, .widget-area-right .contact-widget-info > p a:hover, .testimonial-style-default .testimonial-inner::after, i.breadcrumb-delimiter, .sticky-head.header-sticky .header-navbar a.h-phone:hover, .shop_table.cart td.product-price .amount, .shop_table.cart td.product-subtotal .amount, .elementor-widget-ceaposts .blog-inner .read-more:after, .insta-footer-wrap .sub-title:before, .single-cea-team .team-social-wrap ul.social-icons > li > a i, .widget-service-icon i.widget-icon, .sidebar-broucher .icon-box a, .contact-widget-info > p a:hover, ul.mobile-menu li.menu-item-has-children > span.down-arrow:after, ul.mobile-menu li.menu-item-has-children > span.up-arrow:after, .entry-content p.wp-block-tag-cloud a.tag-cloud-link:hover, .woocommerce ul.products li.product:hover .woocommerce-loop-product__title, .woocommerce div ul.products li.product .price, .woocommerce table.shop_table tbody:first-child tr:first-child td, .woocommerce-checkout .woocommerce-checkout-review-order .cart-subtotal .woocommerce-Price-amount.amount, .woocommerce table.shop_table td,.product_meta>span a:hover, .full-search-wrapper .search-form .input-group .btn, .secondary-bar-inner a.secondary-menu-toggle.active:before, .insta-footer-wrap .sub-title, .service-inner .read-more:after, .contact-widget-info > p > span.bi, ul.nav.post-meta > li.post-date > a:hover, ul.nav.post-meta > li.post-author > a:hover, .single-post ul.nav.post-meta > li.post-category:before, .blog .grankare-masonry .post-meta .post-more a, .grankare-masonry .bottom-meta-wrap .post-meta .post-more a, .isotope-filter ul.nav li:hover a:after, .isotope-filter ul.nav li.active a:after, .woocommerce-info::before, .woocommerce div.product form.cart .group_table td .woocommerce-Price-amount.amount {
		color: '. esc_attr( $primary_color ) .';
	}';
	echo '.widget.widget_nav_menu li a:before, .grankare-masonry .bottom-meta-wrap .post-meta li.post-share-wrap .social-share a:hover, .single-post ul.social-share > li > a:hover, .post-share-wrap ul.social-share > li > a, .custom-post-nav a:hover > *  {
			color: '. esc_attr( $primary_color ) .' !important;
		}';
	echo '.woocommerce-message,
.woocommerce #content div.product .woocommerce-tabs ul.tabs, .woocommerce div.product .woocommerce-tabs ul.tabs, .woocommerce-page #content div.product .woocommerce-tabs ul.tabs, .woocommerce-page div.product .woocommerce-tabs ul.tabs, .contact-form-wrapper span.wpcf7-form-control-wrap input:focus, .contact-form-wrapper span.wpcf7-form-control-wrap select:focus, .contact-form-wrapper span.wpcf7-form-control-wrap textarea:focus, .single-post .comments-wrapper.section-inner input:focus, .single-post .comments-wrapper.section-inner textarea:focus, .modal-popup-body input.wpcf7-form-control:focus, 
.modal-popup-body textarea.wpcf7-form-control:focus, .wp-block-search__input:focus, footer .mailchimp-wrapper .input-group input#zozo-mc-email:focus, .single-cea-testimonial .testimonial-info img, .cus-float-img .float-parallax img, .comments-wrapper.section-inner input:focus, .comments-wrapper.section-inner textarea:focus, ul.nav.pagination.post-pagination > li > a, ul.nav.pagination.post-pagination > li > span, .comments-pagination.pagination .page-numbers, .team-wrapper.team-style-default .team-inner > .post-thumb img.img-fluid.rounded-circle, .testimonial-wrapper.testimonial-style-list .post-thumb img, .timeline > li:hover .timeline-panel, nav.post-nav-links .post-page-numbers, a.mobile-menu-toggle > span,
.elementor-widget-ceaposts .blog-inner .read-more:before, .service-inner .read-more:before,
.insta-footer-wrap .sub-title:after, .owl-carousel button.owl-dot, .text-left .feature-box-classic .feature-box-title:before, .timeline > li > .timeline-sep-title:before,
.single-cea-team .team-social-wrap ul.social-icons > li > a, .single-cea-team .team-info > *.team-title span.team-designation:before, .portfolio-style-default .portfolio-inner .post-thumb:before,
.woocommerce-cart table.cart td.actions .coupon .input-text:focus, form.form-inline.search-form .input-group > *.form-control:focus, a.mobile-menu-toggle > span, .section-title-wrapper .title-wrap .sub-title:after, .woocommerce-page .woocommerce-info .button, .woocommerce-page .woocommerce-info .button:hover, .woocommerce nav.woocommerce-pagination ul li a, .woocommerce nav.woocommerce-pagination ul li span {
		border-color: '. esc_attr( $primary_color ) .';
	}';	
	echo '.form-control:focus, .woocommerce form .form-row input.input-text:focus, .woocommerce form .form-row textarea:focus, .woocommerce form .form-row .input-text:focus, .woocommerce-page form .form-row .input-text:focus, .select2-container--default.select2-container--open.select2-container--below .select2-selection--single {
		border-color: '. esc_attr( $primary_color ) .' !important;
	}';	
	echo '.testimonial-wrapper.testimonial-style-default .owl-item .testimonial-inner,
	.full-search-wrapper form.form-inline.search-form .form-control:focus {
		border-bottom-color: '. esc_attr( $primary_color ) .';
	}';	
	echo '.woocommerce-info {
		border-top-color: '. esc_attr( $primary_color ) .';
	}';	
	
	echo '.timeline:before {
		border-right-color: '. esc_attr( $primary_color ) .';
	}';	
	echo '.timeline > li:hover > .timeline-panel:after {
		border-left-color: '. esc_attr( $primary_color ) .';
		border-right-color: '. esc_attr( $primary_color ) .';
	}';	
	echo '.cea-counter-wrapper.cea-counter-style-modern .counter-value > *,
	.pricing-style-classic .pricing-table-info > *.price-text span {
		-webkit-text-stroke: 1px '. esc_attr( $primary_color ) .';
	}';		
}

//secondary color
$secondary_color = $grankare_styles->grankare_get_option( 'secondary-color' );
if( $secondary_color ){
	echo '.secondary-color {
		color: '. esc_attr( $secondary_color ) .';
	}';
	echo '.secondary-bg,  .woocommerce ul.products li.product .button:hover {
		background-color: '. esc_attr( $secondary_color ) .';
	}';
	echo '.close:hover,.team-style-classic-pro .team-social-wrap ul.social-icons > li > a:hover,
header a.btn.btn-primary:hover, .search-form .input-group .btn:hover,
.service-style-classic-pro .service-inner:hover .post-details-outer .service-icon-img-wrap {
		background-color: '. esc_attr( $secondary_color ) .';
	}';
	echo '.custom-post-nav a:hover, form.post-password-form input[type="submit"]:hover {
		background-color: '. esc_attr( $secondary_color ) .' !important;
	}';	
}
echo '.full-search-wrapper:before {
	background-image: url('. esc_url( get_template_directory_uri() . '/assets/images/heart-shape.png' ) .'); 
	
}';
echo '.feature-box-wrapper.feature-box-classic .fbox-number:after {
	background-image: url('. esc_url( get_template_directory_uri() . '/assets/images/process-plug.png' ) .'); 
}';
echo '.cus-testimonial-page .testimonial-wrapper.testimonial-style-list .testimonial-inner .post-excerpt::before {
	background-image: url('. esc_url( get_template_directory_uri() . '/assets/images/left-quote-1.png' ) .'); 
}';
echo '.site-footer:before {
	background-image: url('. esc_url( get_template_directory_uri() . '/assets/images/footer_bg.png' ) .'); 
}';
//body background if boxed
$grankare_styles->grankare_bg_settings( 'site-bg', 'body' );

//button color keys -> fore, bg, border, hfore, hbg, hborder
echo '.btn, button, .back-to-top,.header-navbar a.btn.btn-primary, .widget_search .search-form .input-group .btn,button.wp-block-search__button,.btn.bordered:hover,.close,
button.wp-block-search__button,ul.nav.pagination.post-pagination > li > span,.comment-respond input[type="submit"],.wp-block-button__link,.button.button-primary, input[type=button], input[type="submit"], header .mini-cart-dropdown ul.cart-dropdown-menu > li.mini-view-cart a, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt,a.zozo-woo-compare-ajax.zozo-btn, .mini-view-wishlist a, .mini-view-cart a,.woocommerce .woocommerce-error .button, .woocommerce .woocommerce-info .button, .woocommerce .woocommerce-message .button, .woocommerce-page .woocommerce-error .button, .woocommerce-page .woocommerce-info .button, .woocommerce-page .woocommerce-message .button, a.zozo-compare-close, a.zozo-sticky-cart-close, a.zozo-sticky-wishlist-close  {';
	$grankare_styles->grankare_button_color( 'button-color', 'fore' );
	$grankare_styles->grankare_button_color( 'button-color', 'bg' );
	$grankare_styles->grankare_button_color( 'button-color', 'border' );
echo '}';
echo '.btn:hover, button:hover, .post-category a:hover, .back-to-top:hover, .widget_search .search-form .input-group .btn:hover, button.wp-block-search__button:hover, .btn:focus, button:focus, .post-category a:focus, .back-to-top:focus, .widget_search .search-form .input-group .btn:focus, button.wp-block-search__button:focus, .btn:active, button:active, .post-category a:active, .back-to-top:active,.header-navbar a.btn.btn-primary:active, .widget_search .search-form .input-group .btn:active, button.wp-block-search__button:active,.contact-form-wrapper input.wpcf7-form-control.wpcf7-submit:hover, input[type="submit"]:hover, header .mini-cart-dropdown ul.cart-dropdown-menu > li.mini-view-cart a:hover,nav.post-nav-links .post-page-numbers:hover, .wp-block-button.is-style-outline a.wp-block-button__link:hover, ul.nav.pagination.post-pagination > li > a:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover,a.zozo-woo-compare-ajax.zozo-btn:hover, .mini-view-wishlist a:hover, .mini-view-cart a:hover,.woocommerce .woocommerce-error .button:hover, .woocommerce .woocommerce-info .button:hover, .woocommerce .woocommerce-message .button:hover, .woocommerce-page .woocommerce-error .button:hover, .woocommerce-page .woocommerce-info .button:hover, .woocommerce-page .woocommerce-message .button:hover, a.zozo-compare-close:hover, a.zozo-sticky-cart-close:hover, a.zozo-sticky-wishlist-close:hover {';
	$grankare_styles->grankare_button_color( 'button-color', 'hfore' );	
	$grankare_styles->grankare_button_color( 'button-color', 'hborder' );
echo '}';

//site link color
$grankare_styles->grankare_link_color( 'link-color', 'regular', '.header-topbar a' );
$grankare_styles->grankare_link_color( 'link-color', 'hover', '.header-topbar a:hover' );
$grankare_styles->grankare_link_color( 'link-color', 'active', '.header-topbar a:active, .header-topbar a:focus , a:active , a:focus ' );

//site padding
$grankare_styles->grankare_padding_settings( 'site-padding', '.grankare-content-wrap' );

//mobile header style
$mobilebar_from = $grankare_styles->grankare_get_option( 'mobilebar-responsive' );
$mobilebar_from = $mobilebar_from ? absint( $mobilebar_from ) : 767;
echo '@media only screen and ( max-width: '. esc_attr( $mobilebar_from ) .'px ) {';
	echo '.header-mobilebar { display: flex; }';
	echo '.site-header { display: none; }';
echo '}';
echo '@media only screen and ( min-width: '. esc_attr( $mobilebar_from + 1 ) .'px ) {';
	echo '.site-header { display: block; }';
	echo '.header-mobilebar { display: none; }';
echo '}';

//page loader
$page_loader = $grankare_styles->grankare_image_settings('page_loader');
if( isset( $page_loader['url'] ) && !empty( $page_loader['url'] ) ){
	echo '.page-loader { background-image: url('. esc_url( $page_loader['url']  ) .'); }';
}

//body typo styles
$grankare_styles->grankare_typo_settings( 'content-typography', 'body' );

//lead typo styles
$grankare_styles->grankare_typo_settings( 'lead-typography', '.lead' );

//h1 typo styles
$grankare_styles->grankare_typo_settings( 'h1-typography', 'h1, .h1' );

//h2 typo styles
$grankare_styles->grankare_typo_settings( 'h2-typography', 'h2, .h2' );

//h3 typo styles
$grankare_styles->grankare_typo_settings( 'h3-typography', 'h3, .h3' );

//h4 typo styles
$grankare_styles->grankare_typo_settings( 'h4-typography', 'h4, .h4' );

//h5 typo styles
$grankare_styles->grankare_typo_settings( 'h5-typography', 'h5, .h5' );

//h6 typo styles
$grankare_styles->grankare_typo_settings( 'h6-typography', 'h6, .h6' );

//header typo styles & link color
$grankare_styles->grankare_typo_settings( 'header-typography', '.site-header' );
$grankare_styles->grankare_link_color( 'header-links-color', 'regular', '.site-header a' );
$grankare_styles->grankare_link_color( 'header-links-color', 'hover', '.site-header a:hover' );
$grankare_styles->grankare_link_color( 'header-links-color', 'active', '.site-header a:active' );
$grankare_styles->grankare_bg_settings( 'header-background', '.site-header' );
$grankare_styles->grankare_padding_settings( 'header-padding', '.site-header' );
$grankare_styles->grankare_margin_settings( 'header-margin', '.site-header' );
$grankare_styles->grankare_border_settings( 'header-border', '.site-header' );

//dropdown style
$grankare_styles->grankare_bg_settings( 'dropdown-background', '.primary-menu .menu-item-has-children ul.sub-menu' );
$grankare_styles->grankare_link_color( 'dropdown-links-color', 'regular', '.primary-menu .menu-item-has-children ul.sub-menu li a' );
$grankare_styles->grankare_link_color( 'dropdown-links-color', 'hover', '.primary-menu .menu-item-has-children ul.sub-menu li a:hover' );
$grankare_styles->grankare_link_color( 'dropdown-links-color', 'active', '.primary-menu .menu-item-has-children ul.sub-menu li a:active, .primary-menu li.current-menu-parent > ul.sub-menu > li.current-menu-item > a,
.primary-menu li.current-menu-parent > ul.sub-menu > li.current-menu-ancestor.current-menu-item > a, ul.wp-menu ul.sub-menu li.menu-item.current-menu-ancestor.menu-item-has-children > a' );



//dropdown on sticky style
$grankare_styles->grankare_bg_settings( 'dropdown-sticky-background', '.sticky-head.header-sticky .primary-menu .menu-item-has-children ul.sub-menu li' );
$grankare_styles->grankare_link_color( 'dropdown-sticky-links-color', 'regular', '.sticky-head.header-sticky .primary-menu .menu-item-has-children ul.sub-menu li a' );
$grankare_styles->grankare_link_color( 'dropdown-sticky-links-color', 'hover', '.sticky-head.header-sticky .primary-menu .menu-item-has-children ul.sub-menu li a:hover' );
$grankare_styles->grankare_link_color( 'dropdown-sticky-links-color', 'active', '.sticky-head.header-sticky .primary-menu .menu-item-has-children ul.sub-menu li a:active, .sticky-head.header-sticky .primary-menu li.current-menu-parent > ul.sub-menu > li.current-menu-item > a, .sticky-head.header-sticky .primary-menu li.current-menu-parent > ul.sub-menu > li.current-menu-ancestor.current-menu-item > a,.sticky-head.header-sticky ul.wp-menu ul.sub-menu li.menu-item.current-menu-ancestor.menu-item-has-children > a' );

//header topbar typo styles
$grankare_styles->grankare_typo_settings( 'header-topbar-typography', '.header-topbar' );

//header topbar styles & link color
$topbar_height = $grankare_styles->grankare_get_option('header-topbar-height');
if( !empty( $topbar_height ) && isset( $topbar_height['height'] ) && !empty( $topbar_height['height'] ) ){
	echo '.header-topbar {';
		echo 'line-height: '. esc_attr( $topbar_height['height'] ) .'px;';
	echo '}';
}

$topbar_sticky_height = $grankare_styles->grankare_get_option('header-topbar-sticky-height');
if( !empty( $topbar_sticky_height ) && isset( $topbar_sticky_height['height'] ) && !empty( $topbar_sticky_height['height'] ) ){
	echo '.header-sticky .header-topbar {';
		echo 'line-height: '. esc_attr( $topbar_sticky_height['height'] ) .'px;';
	echo '}';
}

$grankare_styles->grankare_bg_settings( 'header-topbar-background', '.header-topbar' );
$grankare_styles->grankare_padding_settings( 'header-topbar-padding', '.header-topbar' );
$grankare_styles->grankare_margin_settings( 'header-topbar-margin', '.header-topbar' );
$grankare_styles->grankare_border_settings( 'header-topbar-border', '.header-topbar' );
$grankare_styles->grankare_link_color( 'header-topbar-links-color', 'regular', '.header-topbar a' );
$grankare_styles->grankare_link_color( 'header-topbar-links-color', 'hover', '.header-topbar a:hover' );
$grankare_styles->grankare_link_color( 'header-topbar-links-color', 'active', '.header-topbar a:active, .header-topbar ul.wp-menu > li.current-menu-item > a,.header-topbar ul.nav.wp-menu > li.menu-item-has-children.current_page_parent > a, .header-topbar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a' );

//topbar on sticky style
$grankare_styles->grankare_bg_settings( 'header-topbar-sticky-background', '.sticky-head.header-sticky .header-topbar' );
$grankare_styles->grankare_link_color( 'header-topbar-sticky-links-color', 'regular', '.sticky-head.header-sticky .header-topbar a' );
$grankare_styles->grankare_link_color( 'header-topbar-sticky-links-color', 'hover', '.sticky-head.header-sticky .header-topbar a:hover' );
$grankare_styles->grankare_link_color( 'header-topbar-sticky-links-color', 'active', '.sticky-head.header-sticky .header-topbar a:active, .sticky-head.header-sticky .header-topbar ul.wp-menu > li.current-menu-item > a, .sticky-head.header-sticky .header-topbar ul.nav.wp-menu > li.menu-item-has-children.current_page_parent > a,.sticky-head.header-sticky .header-topbar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a'  );

//header logobar typo styles
$grankare_styles->grankare_typo_settings( 'header-logobar-typography', '.header-logobar' );

//header logobar styles & link color
$logobar_height = $grankare_styles->grankare_get_option('header-logobar-height');
if( !empty( $logobar_height ) && isset( $logobar_height['height'] ) && !empty( $logobar_height['height'] ) ){
	echo '.header-logobar {';
		echo 'line-height: '. esc_attr( $logobar_height['height'] ) .'px;';
	echo '}';
}

$logobar_sticky_height = $grankare_styles->grankare_get_option('header-logobar-sticky-height');
if( !empty( $logobar_sticky_height ) && isset( $logobar_sticky_height['height'] ) && !empty( $logobar_sticky_height['height'] ) ){
	echo '.header-sticky .header-logobar {';
		echo 'line-height: '. esc_attr( $logobar_sticky_height['height'] ) .'px;';
	echo '}';
}

$grankare_styles->grankare_bg_settings( 'header-logobar-background', '.header-logobar' );
$grankare_styles->grankare_padding_settings( 'header-logobar-padding', '.header-logobar' );
$grankare_styles->grankare_margin_settings( 'header-logobar-margin', '.header-logobar' );
$grankare_styles->grankare_border_settings( 'header-logobar-border', '.header-logobar' ); 
$grankare_styles->grankare_link_color( 'header-logobar-links-color', 'regular', '.header-logobar a' );
$grankare_styles->grankare_link_color( 'header-logobar-links-color', 'hover', '.header-logobar a:hover' );
$grankare_styles->grankare_link_color( 'header-logobar-links-color', 'active', '.header-logobar a:active, .header-logobar ul.wp-menu > li.current-menu-item > a,.header-logobar ul.nav.wp-menu > li.menu-item-has-children.current_page_parent > a, .header-logobar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a' );

//logobar on sticky style
$grankare_styles->grankare_bg_settings( 'header-logobar-sticky-background', '.sticky-head.header-sticky .header-logobar' );
$grankare_styles->grankare_link_color( 'header-logobar-sticky-links-color', 'regular', '.sticky-head.header-sticky .header-logobar a' );
$grankare_styles->grankare_link_color( 'header-logobar-sticky-links-color', 'hover', '.sticky-head.header-sticky .header-logobar a:hover' );
$grankare_styles->grankare_link_color( 'header-logobar-sticky-links-color', 'active', '.sticky-head.header-sticky .header-logobar a:active, .sticky-head.header-sticky .header-logobar ul.wp-menu > li.current-menu-item > a, .sticky-head.header-sticky .header-logobar ul.nav.wp-menu > li.menu-item-has-children.current_page_parent > a,.sticky-head.header-sticky .header-logobar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a' );

//header navbar typo styles
$grankare_styles->grankare_typo_settings( 'header-navbar-typography', '.header-navbar' );

//header navbar styles & link color
$navbar_height = $grankare_styles->grankare_get_option('header-navbar-height');
if( !empty( $navbar_height ) && isset( $navbar_height['height'] ) && !empty( $navbar_height['height'] ) ){
	echo '.header-navbar {';
		echo 'line-height: '. esc_attr( $navbar_height['height'] ) .'px;';
	echo '}';
}

$navbar_sticky_height = $grankare_styles->grankare_get_option('header-navbar-sticky-height');
if( !empty( $navbar_sticky_height ) && isset( $navbar_sticky_height['height'] ) && !empty( $navbar_sticky_height['height'] ) ){
	echo '.header-sticky .header-navbar {';
		echo 'line-height: '. esc_attr( $navbar_sticky_height['height'] ) .'px;';
	echo '}';
}

$grankare_styles->grankare_bg_settings( 'header-navbar-background', '.header-navbar' );
$grankare_styles->grankare_padding_settings( 'header-navbar-padding', '.header-navbar' );
$grankare_styles->grankare_margin_settings( 'header-navbar-margin', '.header-navbar' );
$grankare_styles->grankare_border_settings( 'header-navbar-border', '.header-navbar' );
$grankare_styles->grankare_link_color( 'header-navbar-links-color', 'regular', '.header-navbar a' );
$grankare_styles->grankare_link_color( 'header-navbar-links-color', 'hover', '.header-navbar a:hover' );
$grankare_styles->grankare_link_color( 'header-navbar-links-color', 'active', '.header-navbar a:active, .header-navbar ul.wp-menu > li.current-menu-item > a, .header-navbar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a' );

//navbar on sticky style
$grankare_styles->grankare_bg_settings( 'header-navbar-sticky-background', '.sticky-head.header-sticky .header-navbar' );
$grankare_styles->grankare_link_color( 'header-navbar-sticky-links-color', 'regular', '.sticky-head.header-sticky .header-navbar a' );
$grankare_styles->grankare_link_color( 'header-navbar-sticky-links-color', 'hover', '.sticky-head.header-sticky .header-navbar a:hover' );
$grankare_styles->grankare_link_color( 'header-navbar-sticky-links-color', 'active', '.sticky-head.header-sticky .header-navbar a:active, .sticky-head.header-sticky .header-navbar ul.wp-menu > li.current-menu-item > a, .sticky-head.header-sticky .header-navbar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a, .sticky-head.header-sticky .header-navbar a.active' );

//logo styles
$site_logo_width = $grankare_styles->grankare_get_option('site-logo-width');
if( !empty( $site_logo_width ) && isset( $site_logo_width['width'] ) && !empty( $site_logo_width['width'] ) ){
	echo 'img.site-logo { max-width: '. esc_attr( $site_logo_width['width'] ) .'px; }';
}
$sticky_logo_width = $grankare_styles->grankare_get_option('sticky-logo-width');
if( !empty( $sticky_logo_width ) && isset( $sticky_logo_width['width'] ) && !empty( $sticky_logo_width['width'] ) ){
	echo 'img.sticky-logo { max-width: '. esc_attr( $sticky_logo_width['width'] ) .'px; }';
}
$mobile_logo_width = $grankare_styles->grankare_get_option('mobile-logo-width');
if( !empty( $mobile_logo_width ) && isset( $mobile_logo_width['width'] ) && !empty( $mobile_logo_width['width'] ) ){
	echo 'img.mobile-logo { max-width: '. esc_attr( $mobile_logo_width['width'] ) .'px; }';
}


//blog page title settings
$grankare_styles->grankare_color( 'blog-title-color', '.blog .page-title-wrap .page-title' );
$grankare_styles->grankare_color( 'blog-title-desc-color', '.blog .page-title-wrap .page-subtitle' );
$grankare_styles->grankare_link_color( 'blog-title-link-color', 'regular', '.blog .page-title-wrap .breadcrumb a' );
$grankare_styles->grankare_link_color( 'blog-title-link-color', 'hover', '.blog .page-title-wrap .breadcrumb a:hover' );
$grankare_styles->grankare_link_color( 'blog-title-link-color', 'active', '.blog .page-title-wrap .breadcrumb a:active' );
$grankare_styles->grankare_bg_settings( 'blog-title-bg', '.blog .grankare-page-header' );
$grankare_styles->grankare_padding_settings( 'blog-title-padding', '.blog .page-title-wrap' );

//archive page title settings
$grankare_styles->grankare_color( 'archive-title-color', '.archive .page-title-wrap .page-title, .search .page-title-wrap .page-title' );
$grankare_styles->grankare_color( 'archive-title-desc-color', '.archive .page-title-wrap .page-subtitle, .search .page-title-wrap .page-subtitle' );
$grankare_styles->grankare_link_color( 'archive-title-link-color', 'regular', '.archive .page-title-wrap .breadcrumb a, .search .page-title-wrap .breadcrumb a' );
$grankare_styles->grankare_link_color( 'archive-title-link-color', 'hover', '.archive .page-title-wrap .breadcrumb a:hover, .search .page-title-wrap .breadcrumb a:hover' );
$grankare_styles->grankare_link_color( 'archive-title-link-color', 'active', '.archive .page-title-wrap .breadcrumb a:active, .search .page-title-wrap .breadcrumb a:active' );
$grankare_styles->grankare_bg_settings( 'archive-title-bg', '.archive .grankare-page-header, .search .grankare-page-header' );
$grankare_styles->grankare_padding_settings( 'archive-title-padding', '.archive .page-title-wrap, .search .page-title-wrap' );

//single post page title settings
$grankare_styles->grankare_color( 'single-title-color', '.single-post .page-title-wrap .page-title' );
$grankare_styles->grankare_color( 'single-title-desc-color', '.single-post .page-title-wrap .page-subtitle' );
$grankare_styles->grankare_link_color( 'single-title-link-color', 'regular', '.single-post .page-title-wrap .breadcrumb a' );
$grankare_styles->grankare_link_color( 'single-title-link-color', 'hover', '.single-post .page-title-wrap .breadcrumb a:hover' );
$grankare_styles->grankare_link_color( 'single-title-link-color', 'active', '.single-post .page-title-wrap .breadcrumb a:active' );
$grankare_styles->grankare_bg_settings( 'single-title-bg', '.single-post .grankare-page-header' );
$grankare_styles->grankare_padding_settings( 'single-title-padding', '.single-post .page-title-wrap' );

//page title settings
$grankare_styles->grankare_color( 'page-title-color', '.page .page-title-wrap .page-title, .error404 .page-title-wrap .page-title' );
$grankare_styles->grankare_color( 'page-title-desc-color', '.page .page-title-wrap .page-subtitle, .error404 .page-title-wrap .page-subtitle' );
$grankare_styles->grankare_link_color( 'page-title-link-color', 'regular', '.page .page-title-wrap .breadcrumb a, .error404 .page-title-wrap .breadcrumb a' );
$grankare_styles->grankare_link_color( 'page-title-link-color', 'hover', '.page .page-title-wrap .breadcrumb a:hover, .error404 .page-title-wrap .breadcrumb a:hover' );
$grankare_styles->grankare_link_color( 'page-title-link-color', 'active', '.page .page-title-wrap .breadcrumb a:active, .error404 .page-title-wrap .breadcrumb a:active' );
$grankare_styles->grankare_bg_settings( 'page-title-bg', '.page .grankare-page-header, .error404 .grankare-page-header' );
$grankare_styles->grankare_padding_settings( 'page-title-padding', '.page .page-title-wrap, .error404 .page-title-wrap' );

//single product page title settings
$grankare_styles->grankare_color( 'product-title-color', '.single-product .page-title-wrap .page-title' );
$grankare_styles->grankare_color( 'product-title-desc-color', '.single-product .page-title-wrap .page-subtitle' );
$grankare_styles->grankare_link_color( 'product-title-link-color', 'regular', '.single-product .page-title-wrap .breadcrumb a' );
$grankare_styles->grankare_link_color( 'product-title-link-color', 'hover', '.single-product .page-title-wrap .breadcrumb a:hover' );
$grankare_styles->grankare_link_color( 'product-title-link-color', 'active', '.single-product .page-title-wrap .breadcrumb a:active' );
$grankare_styles->grankare_bg_settings( 'product-title-bg', '.single-product .grankare-page-header' );
$grankare_styles->grankare_padding_settings( 'product-title-padding', '.single-product .page-title-wrap' );

//Custom Post Single title settings
$grankare_styles->grankare_color( 'custom-single-title-color', '.single[class*="single-cea-"] .page-title-wrap .page-title' );
$grankare_styles->grankare_color( 'custom-single-title-desc-color', '.single[class*="single-cea-"] .page-title-wrap .page-subtitle' );
$grankare_styles->grankare_link_color( 'custom-single-title-link-color', 'regular', '.single[class*="single-cea-"] .page-title-wrap .breadcrumb a' );
$grankare_styles->grankare_link_color( 'custom-single-title-link-color', 'hover', '.single[class*="single-cea-"] .page-title-wrap .breadcrumb a:hover' );
$grankare_styles->grankare_link_color( 'custom-single-title-link-color', 'active', '.single[class*="single-cea-"] .page-title-wrap .breadcrumb a:active' );
$grankare_styles->grankare_bg_settings( 'custom-single-title-bg', '.single[class*="single-cea-"] .grankare-page-header' );
$grankare_styles->grankare_padding_settings( 'custom-single-title-padding', '.single[class*="single-cea-"] .page-title-wrap' );

//Custom Post Service Single title settings
$grankare_styles->grankare_color( 'cea-service-title-color', '.single.single-cea-service .page-title-wrap .page-title' );
$grankare_styles->grankare_color( 'cea-service-title-desc-color', '.single.single-cea-service .page-title-wrap .page-subtitle' );
$grankare_styles->grankare_link_color( 'cea-service-title-link-color', 'regular', '.single.single-cea-service .page-title-wrap .breadcrumb a' );
$grankare_styles->grankare_link_color( 'cea-service-title-link-color', 'hover', '.single.single-cea-service .page-title-wrap .breadcrumb a:hover' );
$grankare_styles->grankare_link_color( 'cea-service-title-link-color', 'active', '.single.single-cea-service .page-title-wrap .breadcrumb a:active' );
$grankare_styles->grankare_bg_settings( 'cea-service-title-bg', '.single.single-cea-service .grankare-page-header' );
$grankare_styles->grankare_padding_settings( 'cea-service-title-padding', '.single.single-cea-service .page-title-wrap' );

//Custom Post Team Single title settings
$grankare_styles->grankare_color( 'cea-team-title-color', '.single.single-cea-team .page-title-wrap .page-title' );
$grankare_styles->grankare_color( 'cea-team-title-desc-color', '.single.single-cea-team .page-title-wrap .page-subtitle' );
$grankare_styles->grankare_link_color( 'cea-team-title-link-color', 'regular', '.single.single-cea-team .page-title-wrap .breadcrumb a' );
$grankare_styles->grankare_link_color( 'cea-team-title-link-color', 'hover', '.single.single-cea-team .page-title-wrap .breadcrumb a:hover' );
$grankare_styles->grankare_link_color( 'cea-team-title-link-color', 'active', '.single.single-cea-team .page-title-wrap .breadcrumb a:active' );
$grankare_styles->grankare_bg_settings( 'cea-team-title-bg', '.single.single-cea-team .grankare-page-header' );
$grankare_styles->grankare_padding_settings( 'cea-team-title-padding', '.single.single-cea-team .page-title-wrap' );

//Custom Post Testimonial Single title settings
$grankare_styles->grankare_color( 'cea-testimonial-title-color', '.single.single-cea-testimonial .page-title-wrap .page-title' );
$grankare_styles->grankare_color( 'cea-testimonial-title-desc-color', '.single.single-cea-testimonial .page-title-wrap .page-subtitle' );
$grankare_styles->grankare_link_color( 'cea-testimonial-title-link-color', 'regular', '.single.single-cea-testimonial .page-title-wrap .breadcrumb a' );
$grankare_styles->grankare_link_color( 'cea-testimonial-title-link-color', 'hover', '.single.single-cea-testimonial .page-title-wrap .breadcrumb a:hover' );
$grankare_styles->grankare_link_color( 'cea-testimonial-title-link-color', 'active', '.single.single-cea-testimonial .page-title-wrap .breadcrumb a:active' );
$grankare_styles->grankare_bg_settings( 'cea-testimonial-title-bg', '.single.single-cea-testimonial .grankare-page-header' );
$grankare_styles->grankare_padding_settings( 'cea-testimonial-title-padding', '.single.single-cea-testimonial .page-title-wrap' );

//Custom Post Portfolio Single title settings
$grankare_styles->grankare_color( 'cea-portfolio-title-color', '.single.single-cea-portfolio .page-title-wrap .page-title' );
$grankare_styles->grankare_color( 'cea-portfolio-title-desc-color', '.single.single-cea-portfolio .page-title-wrap .page-subtitle' );
$grankare_styles->grankare_link_color( 'cea-portfolio-title-link-color', 'regular', '.single.single-cea-portfolio .page-title-wrap .breadcrumb a' );
$grankare_styles->grankare_link_color( 'cea-portfolio-title-link-color', 'hover', '.single.single-cea-portfolio .page-title-wrap .breadcrumb a:hover' );
$grankare_styles->grankare_link_color( 'cea-portfolio-title-link-color', 'active', '.single.single-cea-portfolio .page-title-wrap .breadcrumb a:active' );
$grankare_styles->grankare_bg_settings( 'cea-portfolio-title-bg', '.single.single-cea-portfolio .grankare-page-header' );
$grankare_styles->grankare_padding_settings( 'cea-portfolio-title-padding', '.single.single-cea-portfolio .page-title-wrap' );

//Custom Post Event Single title settings
$grankare_styles->grankare_color( 'cea-event-title-color', '.single.single-cea-event .page-title-wrap .page-title' );
$grankare_styles->grankare_color( 'cea-event-title-desc-color', '.single.single-cea-event .page-title-wrap .page-subtitle' );
$grankare_styles->grankare_link_color( 'cea-event-title-link-color', 'regular', '.single.single-cea-event .page-title-wrap .breadcrumb a' );
$grankare_styles->grankare_link_color( 'cea-event-title-link-color', 'hover', '.single.single-cea-event .page-title-wrap .breadcrumb a:hover' );
$grankare_styles->grankare_link_color( 'cea-event-title-link-color', 'active', '.single.single-cea-event .page-title-wrap .breadcrumb a:active' );
$grankare_styles->grankare_bg_settings( 'cea-event-title-bg', '.single.single-cea-event .grankare-page-header' );
$grankare_styles->grankare_padding_settings( 'cea-event-title-padding', '.single.single-cea-event .page-title-wrap' );


//footer styles and link color
$grankare_styles->grankare_typo_settings( 'footer-typography', '.site-footer' );
$grankare_styles->grankare_bg_settings( 'footer-background', '.site-footer' );
$grankare_styles->grankare_padding_settings( 'footer-padding', '.site-footer' );
$grankare_styles->grankare_margin_settings( 'footer-margin', '.site-footer' );
$grankare_styles->grankare_border_settings( 'footer-border', '.site-footer' );
$grankare_styles->grankare_link_color( 'footer-links-color', 'regular', '.site-footer a' );
$grankare_styles->grankare_link_color( 'footer-links-color', 'hover', '.site-footer a:hover' );
$grankare_styles->grankare_link_color( 'footer-links-color', 'active', '.site-footer a:active' );

//footer top styles and link color
$grankare_styles->grankare_typo_settings( 'insta-footer-typography', '.insta-footer-wrap' );
$grankare_styles->grankare_bg_settings( 'insta-footer-background', '.insta-footer-wrap' );
$grankare_styles->grankare_padding_settings( 'insta-footer-padding', '.insta-footer-wrap' );
$grankare_styles->grankare_margin_settings( 'insta-footer-margin', '.insta-footer-wrap' );
$grankare_styles->grankare_border_settings( 'insta-footer-border', '.insta-footer-wrap' );
$grankare_styles->grankare_link_color( 'insta-footer-links-color', 'regular', '.insta-footer-wrap a' );
$grankare_styles->grankare_link_color( 'insta-footer-links-color', 'hover', '.insta-footer-wrap a:hover' );
$grankare_styles->grankare_link_color( 'insta-footer-links-color', 'active', '.insta-footer-wrap a:active' );

//footer widgets part styles and link color
$grankare_styles->grankare_typo_settings( 'footer-widgets-typography', '.footer-widgets-wrap' );
$grankare_styles->grankare_bg_settings( 'footer-widgets-background', '.footer-widgets-wrap' );
$grankare_styles->grankare_padding_settings( 'footer-widgets-padding', '.footer-widgets-wrap' );
$grankare_styles->grankare_margin_settings( 'footer-widgets-margin', '.footer-widgets-wrap' );
$grankare_styles->grankare_border_settings( 'footer-widgets-border', '.footer-widgets-wrap' );
$grankare_styles->grankare_link_color( 'footer-widgets-links-color', 'regular', '.footer-widgets-wrap a' );
$grankare_styles->grankare_link_color( 'footer-widgets-links-color', 'hover', '.footer-widgets-wrap a:hover' );
$grankare_styles->grankare_link_color( 'footer-widgets-links-color', 'active', '.footer-widgets-wrap a:active' );

//footer bottom styles and link color
$grankare_styles->grankare_typo_settings( 'copyright-section-typography', '.footer-bottom-wrap' );
$grankare_styles->grankare_bg_settings( 'copyright-section-background', '.footer-bottom-wrap' );
$grankare_styles->grankare_padding_settings( 'copyright-section-padding', '.footer-bottom-wrap' );
$grankare_styles->grankare_margin_settings( 'copyright-section-margin', '.footer-bottom-wrap' );
$grankare_styles->grankare_border_settings( 'copyright-section-border', '.footer-bottom-wrap' );
$grankare_styles->grankare_link_color( 'copyright-section-links-color', 'regular', '.footer-bottom-wrap a' );
$grankare_styles->grankare_link_color( 'copyright-section-links-color', 'hover', '.footer-bottom-wrap a:hover' );
$grankare_styles->grankare_link_color( 'copyright-section-links-color', 'active', '.footer-bottom-wrap a:active' );

//secondary bar styles
if( $primary_color && $secondary_color ){
	
	echo '.page-load-initiate .page-loader:before, .page-load-end .page-loader:before, .page-load-initiate .page-loader:after, .page-load-end .page-loader:after { 
		background: linear-gradient(90deg, '. esc_attr( $primary_color ) .' 0%, '. esc_attr( $secondary_color ) .' 100%);
		background: -webkit-gradient(linear, left top, right top, from('. esc_attr( $secondary_color ) .'), to('. esc_attr( $primary_color ) .'));
		background: -webkit-linear-gradient(left, '. esc_attr( $secondary_color ) .' 0%, '. esc_attr( $primary_color ) .' 100%);
		background: -o-linear-gradient(left, '. esc_attr( $secondary_color ) .' 0%, '. esc_attr( $primary_color ) .' 100%);
		background: linear-gradient(to right, '. esc_attr( $secondary_color ) .' 0%, '. esc_attr( $primary_color ) .' 100%);
	}';
}
$secondary_sidebar_width = $grankare_styles->grankare_dimension_settings( 'secondary-sidebar-width', 'width' );
if( $secondary_sidebar_width ){
	echo '.secondary-bar-inner {
		width: '. esc_attr( $secondary_sidebar_width ) .';
	}';
	echo '.secondary-bar-wrapper.from-left .secondary-bar-inner {
		left: -'. esc_attr( $secondary_sidebar_width ) .';
	}';
	echo '.secondary-bar-wrapper.from-right .secondary-bar-inner {
		right: -'. esc_attr( $secondary_sidebar_width ) .';
	}';
}

//End style

$styles = ob_get_clean();

$gf_arr = Grankare_Theme_Styles::$grankare_gf_array;
update_option( 'grankare_google_fonts_list', $gf_arr );
update_option( 'grankare_custom_styles', wp_slash( $styles ) );