<?php 

class Grankare_Custom_Sidebars {
	
	private static $_instance = null;

	public function __construct() {
		add_action( 'admin_menu', array( $this, 'grankare_addon_admin_menu' ) );	
		add_action( 'wp_ajax_grankare-custom-sidebar-export', array( $this, 'grankare_custom_sidebar_export' ) );
	}
	
	public static function grankare_addon_admin_menu(){
		add_submenu_page( 
			'grankare-welcome', 
			esc_html__( 'Custom Sidebars', 'grankare-addon' ),
			esc_html__( 'Custom Sidebars', 'grankare-addon' ), 
			'manage_options', 
			'grankare-sidebars', 
			array( 'Grankare_Custom_Sidebars', 'grankare_sidebar_admin_page' )
		);
	}
	
	public static function grankare_sidebar_admin_page(){
		$grankare_theme = wp_get_theme();
	?>
		<div class="grankare-settings-wrap">
			<div class="grankare-header-bar">
				<div class="grankare-header-left">
					<div class="grankare-admin-logo-inline">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/brand-logo.png' ); ?>" alt="grankare-logo">
					</div><!-- .grankare-admin-logo-inline -->
					<h2 class="title"><?php esc_html_e( 'Grankare Custom Sidebars', 'grankare-addon' ); ?><span class="grankare-version"><?php echo esc_attr( $grankare_theme->get( 'Version' ) ); ?></span></h2>
				</div><!-- .grankare-header-left -->
				<div class="grankare-header-right">
					<a href="<?php echo esc_url( 'https://wordpress.zozothemes.com/grankare/' ); ?>" class="button grankare-btn"><?php esc_html_e( 'Live Demo', 'grankare-addon' ); ?></a>
				</div><!-- .grankare-header-right -->
			</div><!-- .grankare-header-bar -->
			
			<div class="grankare-settings-tabs grankare-custom-sidebar-wrap">
				<div id="grankare-general" class="grankare-settings-tab active">
					<div class="container">
						<div class="row">
							<div class="col-4">
								<div class="media admin-box">
									<div class="admin-box-icon mr-3">
										<span class="dashicons dashicons-welcome-widgets-menus"></span>								
									</div>
									<div class="media-body admin-box-info">
										<h3 class="admin-box-title"><?php esc_html_e( 'Add New Sidebar', 'grankare-addon' ); ?></h3>
										<div class="admin-box-content">
											<?php esc_html_e( 'You can add new custom sidebar here. Also we give you option to remove or delete custom sidebars.', 'grankare-addon' ); ?>
										</div>
										<?php
											$sidebars = '';
											$sidebar_opt_name = 'grankare_custom_sidebars';
											$sidebars = get_option( $sidebar_opt_name );
											
											if ( isset( $_POST['grankare_custom_sidebar_nonce'] ) && wp_verify_nonce( $_POST['grankare_custom_sidebar_nonce'], 'grankare-()@)(*^#@!' ) 
											) {
												if( isset( $_POST['grankare_sidebar_name'] ) && !empty( $_POST['grankare_sidebar_name'] ) ){
													
													$sidebar_name = $_POST['grankare_sidebar_name'];
													$sidebar_slug = sanitize_title( $sidebar_name );
													
													if( !empty( $sidebars ) ){
														$sidebars[$sidebar_slug] = $sidebar_name;
													}else{
														$sidebars = array( $sidebar_slug => $sidebar_name );
													}	
													update_option( 'grankare_custom_sidebars', $sidebars );
												}
											}
											
											if ( isset( $_POST['grankare_custom_sidebar_remove_nonce'] ) && wp_verify_nonce( $_POST['grankare_custom_sidebar_remove_nonce'], 'grankare-()I*^*^%@!' ) 
											) {
												$remove_sidebar = isset( $_POST['grankare_sidebar_remove_name'] ) && !empty( $_POST['grankare_sidebar_remove_name'] ) ? $_POST['grankare_sidebar_remove_name'] : '';
												unset( $sidebars[$remove_sidebar] );
												update_option( 'grankare_custom_sidebars', $sidebars );
												$sidebars = get_option( $sidebar_opt_name );
											}
											
										?>
										<form action="" method="post" enctype="multipart/form-data">
											<?php wp_nonce_field( 'grankare-()@)(*^#@!', 'grankare_custom_sidebar_nonce' ); ?>
											<input type="input" name="grankare_sidebar_name" class="custom-sidebar-name" value="" />
										</form>
										<a href="#" class="grankare-btn btn-default custom-sidebar-create"><?php esc_html_e( 'Add', 'grankare-addon' ); ?></a>
									</div>
								</div>
							</div>
							<div class="col-8">
								<div class="admin-box">
									<h3 class="admin-box-title sidebar-title"><?php esc_html_e( 'Custom Sidebars', 'grankare-addon' ); ?></h3>
									<?php if( !empty( $sidebars ) ): ?>
									<form action="" method="post" enctype="multipart/form-data">
									<?php wp_nonce_field( 'grankare-()I*^*^%@!', 'grankare_custom_sidebar_remove_nonce' ); ?>
									<input type="hidden" name="grankare_sidebar_remove_name" id="grankare-sidebar-remove-name" value="" />									
									<table class="grankare-admin-table grankare-custom-sidebar-table">
										<thead>
											<tr>
												<td><?php esc_html_e( 'Name', 'grankare-addon' ); ?></td>
												<td><?php esc_html_e( 'Slug', 'grankare-addon' ); ?></td>
												<td><?php esc_html_e( 'Delete', 'grankare-addon' ); ?></td>
											</tr>
										</thead>
										<tbody>
										<?php
											foreach( $sidebars as $sidebar_slug => $sidebar_name ){
											?>
												<tr>
													<td><?php echo esc_html( $sidebar_name ); ?></td>
													<td><?php echo esc_html( $sidebar_slug ); ?></td>
													<td class="text-center"><a href="#" data-sidebar="<?php echo esc_attr( $sidebar_slug ); ?>" class="grankare-sidebar-remove"><span class="dashicons dashicons-trash"></span></a></td>
												</tr>
											<?php
											}
										?>
										</tbody>
									</table>
									</form>
									<a href="#" class="grankare-btn btn-default custom-sidebar-export"><?php esc_html_e( 'Export as JSON', 'grankare-addon' ); ?></a>
									<?php else: ?>
										<p><?php esc_html_e( 'Sorry! No custom sidebars available.', 'grankare-addon' ); ?></p>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			
		</div>
	<?php
	}
		
	public static function rmdir_recurse($path) {
		$path = rtrim($path, '/').'/';
		$handle = opendir($path);
		while(false !== ($file = readdir($handle))) {
			if($file != '.' and $file != '..' ) {
				$fullpath = $path.$file;
				if(is_dir($fullpath)) self::rmdir_recurse($fullpath); else unlink($fullpath);
			}
		}
		closedir($handle);
		rmdir($path);
	}	
	
	public static function grankare_custom_sidebar_export(){
		$nonce = $_POST['nonce'];  
		if ( ! wp_verify_nonce( $nonce, 'grankare-()@)(*^#@!' ) )
			wp_die ( esc_html__( 'F***', 'grankare-addon' ) );
		
		$sidebars = get_option( 'grankare_custom_sidebars' );
		if( !empty( $sidebars ) ){
			//wp_send_json( $sidebars );
			echo json_encode( $sidebars );
		}else{
			echo '';
		}	
		wp_die();
	}
	
	public static function get_instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

} Grankare_Custom_Sidebars::get_instance();