<?php 
class Grankare_Demo_Importer {
	
	private static $_instance = null;
	
	public static $ins_demo_stat;
	
	public static $ins_demo_id;
	public function __construct() {
		
		$this->set_installed_demo_details();
		
		add_action( 'admin_menu', array( $this, 'grankare_addon_admin_menu' ) );
		
		add_action( 'admin_enqueue_scripts', array( $this, 'grankare_enqueue_admin_script' ) );
		
	}
	
	public static function grankare_addon_admin_menu(){
		add_submenu_page( 
			'grankare-welcome', 
			esc_html__( 'Demo Importer', 'grankare-addon' ),
			esc_html__( 'Demo Importer', 'grankare-addon' ), 
			'manage_options', 
			'grankare-importer', 
			array( 'Grankare_Demo_Importer', 'grankare_demo_import_admin_page' )
		);
	}
	
	private function set_installed_demo_details(){
		self::$ins_demo_stat = get_theme_mod( 'grankare_demo_installed' );
		self::$ins_demo_id = get_theme_mod( 'grankare_installed_demo_id' );
	}
	
	public function grankare_enqueue_admin_script(){
		
		if( isset( $_GET['page'] ) && $_GET['page'] == 'grankare-importer' ){
		
			wp_enqueue_style( 'grankare-confirm', GRANKARE_ADDON_URL . 'admin/extension/demo-importer/assets/css/jquery-confirm.min.css' );
			wp_enqueue_script( 'grankare-confirm', GRANKARE_ADDON_URL . 'admin/extension/demo-importer/assets/js/jquery-confirm.min.js', array( 'jquery' ), '1.0', true ); 
			
			wp_enqueue_script( 'grankare-import-scripts', GRANKARE_ADDON_URL . 'admin/extension/demo-importer/assets/js/demo-import.js', array( 'jquery' ), '1.7.5', true ); 
			
			//Import Localize Script
			$demo_import_args = array(
				'admin_ajax_url' => esc_url( admin_url('admin-ajax.php') ),
				'nonce' => wp_create_nonce('grankare-options-import'),		
				'proceed' => esc_html__('Proceed', 'grankare'),
				'cancel' => esc_html__('Cancel', 'grankare'),
				'process' => esc_html__( 'Processing', 'grankare-addon' ),
				'uninstalling' => esc_html__('Uninstalling...', 'grankare'),
				'uninstalled' => esc_html__('Uninstalled.', 'grankare'),
				'unins_pbm' => esc_html__('Uninstall Problem!.', 'grankare'),
				'downloading' => esc_html__('Demo import process running...', 'grankare'), 
				'grankare_import_url' => admin_url( 'admin.php?page=grankare-importer' ),
				'regenerate_thumbnails_url' => admin_url( 'plugin-install.php?tab=plugin-information&plugin=regenerate-thumbnails' )				
			);
			$demo_import_args = apply_filters( 'grankare_demo_import_args', $demo_import_args );
			wp_localize_script( 'grankare-import-scripts', 'grankare_admin_ajax_var', $demo_import_args );
		}
		
	}
	
	public static function grankare_demo_div_generater( $demo_array ){
		
		$ins_demo_stat = self::$ins_demo_stat;
		$ins_demo_id = self::$ins_demo_id;
		
		$demo_class = '';
		if( $ins_demo_stat == 1 ){
			if( $ins_demo_id == $demo_array['demo_id'] ){
				$demo_class .= ' demo-actived';
			}else{
				$demo_class .= ' demo-inactive';
			}
		}else{
			$demo_class .= ' demo-active';
		}
	
		$revslider = isset( $demo_array['revslider'] ) && $demo_array['revslider'] != '' ? $demo_array['revslider'] : '';
		$media_parts = isset( $demo_array['media_parts'] ) && $demo_array['media_parts'] != '' ? $demo_array['media_parts'] : '';
		
		?>
		
		
		<div class="admin-box demo-wrap">
			<div class="install-plugin-wrap theme zozothemes-demo-item<?php echo esc_attr( $demo_class ); ?>">
				<div class="install-plugin-inner">
				
					<div class="zozo-demo-import-loader zozo-preview-<?php echo esc_attr( $demo_array['demo_id'] ); ?>"><i class="dashicons dashicons-admin-generic"></i></div>
					
					<div class="installation-progress">
						<span class="progress-text"></span>
						<div class="progress">
							<div class="progress-bar" style="width:0%"></div>
						</div>
					</div>
				
					<div class="theme-screenshot zozotheme-screenshot">
						<a href="<?php echo esc_url( $demo_array['demo_url'] ); ?>" target="_blank"><img src="<?php echo esc_url( GRANKARE_ADDON_URL . 'admin/extension/demo-importer/assets/images/demo/' . $demo_array['demo_img'] ); ?>" class="demo-img" /></a>
					</div>
					<div class="install-plugin-right">
						<div class="install-plugin-right-inner">
							<h3 class="theme-name" id="<?php echo esc_attr( $demo_array['demo_id'] ); ?>"><?php echo esc_attr( $demo_array['demo_name'] ); ?></h3>
							
							<a href="#" class="theme-demo-install-custom"><?php esc_html_e( "Custom Choice", "grankare" ); ?></a>
							
							<div class="theme-demo-install-parts" id="<?php echo esc_attr( 'demo-install-parts-'. $demo_array['demo_id'] ); ?>">
							
								<div class="demo-install-instructions">
									<ul class="install-instructions">
										<li><strong><?php esc_html_e( "General", "grankare" ); ?></strong></li>
										<li><?php esc_html_e( 'Choose "Media" -> All the media\'s are ready to be import.', "grankare" ); ?></li>
										<li><?php esc_html_e( 'Choose "Theme Options" -> Theme options are ready to be import.', "grankare" ); ?></li>
										<li><?php esc_html_e( 'Choose "Widgets" -> Custom sidebars and widgets are ready to be import.', "grankare" ); ?></li>
										<?php if( $revslider ) : ?>
										<li><?php esc_html_e( 'Choose "Revolution Sliders" -> Revolution slides are ready to be import.', "grankare" ); ?></li>
										<?php endif; ?>
										<li><?php esc_html_e( 'Choose "All Posts" -> Posts, menus, custom post types are ready to be import.', "grankare" ); ?></li>
										<li><p class="lead"><strong>*</strong><?php esc_html_e( 'If you check "All Posts" and Uncheck any of page, then menu will not imported.', "grankare" ); ?></p></li>
										
										<li><strong><?php esc_html_e( "Pages", "grankare" ); ?></strong></li>
										<li><?php esc_html_e( 'Choose pages which you want to show on your site. If you choose all the pages and check "All Post" menu will be import. If any one will not check even page or All posts, then menu will not import.', "grankare" ); ?></li>
									</ul>
								</div>
							
								<div class="zozo-col-3">
									<h5><?php esc_html_e( "General", "grankare" ); ?></h5>
									<?php
									if( isset( $demo_array['general'] )	 ){
										echo '<ul class="general-install-parts-list">';
										foreach( $demo_array['general'] as $key => $value ){
											echo '<li><input type="checkbox" value="'. esc_attr( $key ) .'" data-text="'. esc_attr( $value ) .'" /> '. esc_html( $value ) .'</li>';
										}
										echo '</ul>';
									}						
									?>
								</div><!-- .zozo-col-3 -->
								<div class="zozo-col-3">
									<h5><?php esc_html_e( "Pages", "grankare" ); ?></h5>
									<?php
									if( isset( $demo_array['pages'] )	 ){
										echo '<ul class="page-install-parts-list">';
										foreach( $demo_array['pages'] as $key => $value ){
											echo '<li><input type="checkbox" value="'. esc_attr( $key ) .'" data-text="'. esc_attr( $value ) .'" /> '. esc_html( $value ) .'</li>';
										}
										echo '</ul>';
									}						
									?>
								</div><!-- .zozo-col-3 -->
								<a href="#" class="theme-demo-install-checkall"><?php esc_html_e( "Check/Uncheck All", "grankare" ); ?></a>
								<p><?php esc_html_e( "Leave empty/uncheck all to full install.", "grankare" ); ?></p>
							</div><!-- .theme-demo-install-parts -->
							<div class="theme-actions theme-buttons">
								<a class="button button-primary button-install-demo" data-demo-id="<?php echo esc_attr( $demo_array['demo_id'] ); ?>" data-revslider="<?php echo esc_attr( $revslider ); ?>" data-media="<?php echo esc_attr( $media_parts ); ?>" href="#">
								<?php esc_html_e( "Import", "grankare" ); ?>
								</a>
								<a class="button button-primary button-uninstall-demo" data-demo-id="<?php echo esc_attr( $demo_array['demo_id'] ); ?>" href="#">
								<?php esc_html_e( "Uninstall", "grankare" ); ?>
								</a>
								<a class="button button-primary" target="_blank" href="<?php echo esc_url( $demo_array['demo_url'] ); ?>">
								<?php esc_html_e( "Preview", "grankare" ); ?>
								</a>
							</div>
							
						</div><!-- .install-plugin-right-inner -->
					</div><!-- .install-plugin-right -->
				</div>
			</div><!-- .admin-box -->
		<?php
	}
	
	public static function grankare_demo_import_admin_page(){
		$grankare_theme = wp_get_theme();
	?>
		<div class="grankare-settings-wrap">
		
			<?php wp_nonce_field( 'grankare_demo_import_*&^^$#(*', 'grankare_demo_import_nonce' ); ?>
		
			<div class="grankare-header-bar">
				<div class="grankare-header-left">
					<div class="grankare-admin-logo-inline">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/brand-logo.png' ); ?>" alt="grankare-logo">
					</div><!-- .grankare-admin-logo-inline -->
					<h2 class="title"><?php esc_html_e( 'Grankare Demo Importer', 'grankare-addon' ); ?></h2>
				</div><!-- .grankare-header-left -->
				<div class="grankare-header-right">
					<a href="<?php echo esc_url( 'https://wordpress.zozothemes.com/grankare/' ); ?>" class="button grankare-btn"><?php esc_html_e( 'Live Demo', 'grankare-addon' ); ?></a>
				</div><!-- .grankare-header-right -->
			</div><!-- .grankare-header-bar -->
			
			<div class="grankare-settings-tabs grankare-demo-import-wrap">
				<div id="grankare-general" class="grankare-settings-tab active">
					<div class="container">
						<div class="row">
							<div class="col-6">							
							<?php
								
								//Demo Classic
								$demo_array = array(
									'demo_id' 	=> 'demo',
									'demo_name' => esc_html__( 'Grankare Main Demo', 'grankare-addon' ),
									'demo_img'	=> 'demo-1.jpg',
									'demo_url'	=> 'https://wordpress.zozothemes.com/grankare/',
									'revslider'	=> '6',
									'media_parts'	=> '31',
									'general'	=> array(
										'media' 		=> esc_html__( "Media", "grankare" ),
										'theme-options' => esc_html__( "Theme Options", "grankare" ),
										'widgets' 		=> esc_html__( "Widgets", "grankare" ),
										'revslider' 	=> esc_html__( "Revolution Sliders", "grankare" ),
										'post' 			=> esc_html__( "All Posts", "grankare" )
									),
									'pages'=> array(
										'1'		=> esc_html__( "Contact Us", "grankare" ),
										'2'	=> esc_html__( "Our Services", "grankare" ),						
										'3'	=> esc_html__( "About  Us", "grankare" ),
										'4'	=> esc_html__( "Frequently asked question", "grankare" ),
										'5'	=> esc_html__( "Our Team", "grankare" ),
										'6'	=> esc_html__( "Blog", "grankare" ),
										'7'	=> esc_html__( "Blog Grid", "grankare" ),
										'8'	=> esc_html__( "Blog List", "grankare" ),
										'9'	=> esc_html__( "Services 2", "grankare" ),
										'10' 	=> esc_html__( "Testimonials", "grankare" ),
										'11'		=> esc_html__( "Portfolio", "grankare" ),
										'12' 	=> esc_html__( "2 Column", "grankare" ),
										'13' 	=> esc_html__( "2 Columns + Sidebar", "grankare" ),
										'14'		=> esc_html__( "3 Columns", "grankare" ),
										'15' 	=> esc_html__( "Services 3", "grankare" ),
										'16'		=> esc_html__( "Cart", "grankare" ),
										'17' 	=> esc_html__( "Checkout", "grankare" ),
										'18' 	=> esc_html__( "My account", "grankare" ),
										'19'	=> esc_html__( "Refund and Returns Policy", "grankare" ),						
										'20'	=> esc_html__( "Portfolio 3 Columns", "grankare" ),
										'21'	=> esc_html__( "Privacy Policy", "grankare" ),
										'22'	=> esc_html__( "Home-2", "grankare" ),
										'23'	=> esc_html__( "Home-4", "grankare" ),
										'24'	=> esc_html__( "Home", "grankare" ),
										'25'	=> esc_html__( "Home-3", "grankare" ),
										'26'	=> esc_html__( "home 5", "grankare" ),
										'27'	=> esc_html__( "Shop", "grankare" ),
										'28'	=> esc_html__( "Home Landing", "grankare" )
									)
									
								);
								self::grankare_demo_div_generater( $demo_array );								
							?>
							
								<div class="theme-requirements" data-requirements="<?php 
									printf( '<h2>%1$s</h2> <p>%2$s</p> <h3>%3$s</h3> <ol><li>%4$s</li></ol>', 
										esc_html__( 'WARNING:', 'grankare-addon' ), 
										esc_html__( 'Importing demo content will give you pages, posts, theme options, sidebars and other settings. This will replicate the live demo. Clicking this option will replace your current theme options and widgets. It can also take a minutes to complete.', 'grankare-addon' ),
										esc_html__( 'DEMO REQUIREMENTS:', 'grankare-addon' ),
										esc_html__( 'Memory Limit of 128 MB and max execution time (php time limit) of 300 seconds.', 'grankare-addon' )
									);
								?>">
								</div>							
								
							</div>
						</div>
					</div>
				</div>
			</div>
			
		</div>
	<?php
	}
	
	public static function get_instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}
} Grankare_Demo_Importer::get_instance();
/* Demo Import AJAX */
if( ! function_exists('grankare_demo_import_fun') ) {
    function grankare_demo_import_fun() {
		
		if( ! isset( $_POST['nonce'] ) || ! wp_verify_nonce( $_POST['nonce'], 'grankare_demo_import_*&^^$#(*' ) ) {
			echo "!security issue";
			wp_die(); 
		}
		
		$process = isset( $_POST['process'] ) ? $_POST['process'] : '';
		
		if( $process ){
			
			include GRANKARE_ADDON_DIR . 'admin/extension/demo-importer/zozo-importer.php';
			
			if( $process == 'permission' ){
				grankareZozoImporterModule::grankare_check_file_access_permission();
			}elseif( $process == 'general_download' ){
				grankareZozoImporterModule::grankare_general_file_ajax();
			}elseif( $process == 'xml_download' ){
				grankareZozoImporterModule::grankare_xml_file_ajax();
			}elseif( $process == 'general_install' ){
				grankareZozoImporterModule::grankare_general_file_install_ajax();
			}elseif( $process == 'xml_install' ){
				grankareZozoImporterModule::grankare_xml_file_install_ajax();
			}elseif( $process == 'final' ){
				grankareZozoImporterModule::grankare_import_set_default_settings();
			}elseif( $process == 'uninstall' ){
				grankareZozoImporterModule::grankare_uninstall_demo();
			}
			
		}
		
		wp_die();
		
    }
    add_action('wp_ajax_grankare_demo_import', 'grankare_demo_import_fun');
}
