/*
 * Zozo Megamenu Framework
 * 
 */
( function( $ ) {
	"use strict";
	
	var _cur_menu = '';
	var _cur_json = '';
	var _cur_depth = '';
	var _parent_0 = '';
	var _t_cur_json = '';

	$(document).ready(function() {
		
		$(document).find('.grankare-general-settings-form').magnificPopup({
			type: 'inline',
			preloader: false,
			callbacks: {
				close: function() {
					$("#grankare-general-settings-form").removeClass("megamenu-actived menu-depth-"+_cur_depth);
				},
				beforeOpen: function() {

					_cur_menu = _cur_json = _cur_depth = _t_cur_json = '';

					_cur_menu = "#edit-menu-item-grankare-" + $(this.st.el).data("menu");
					_cur_depth = $(this.st.el).data("depth");
					_cur_json = JSON.parse($(_cur_menu).val());

					if( _cur_json.icon ) $("select.grankare-menu-icons").val(_cur_json.icon);
					else $("select.grankare-menu-icons").val(null);

					if( _cur_json.megamenu ) $("input.grankare-megamenu-option").prop( "checked", true );
					else $("input.grankare-megamenu-option").prop( "checked", false );

					if( _cur_json.megamenucol ) $("select.grankare-megamenu-col").val(_cur_json.megamenucol);
					else $("select.grankare-megamenu-col").val('12');

					if( _cur_json.megamenuwidget ) $("select.grankare-megamenu-widget").val(_cur_json.megamenuwidget);
					else $("select.grankare-megamenu-widget").val(null);

					$("#grankare-general-settings-form").addClass("menu-depth-"+_cur_depth);
					if( _cur_depth !== 0 ) {
						_cur_json.megamenu = 0;
						_parent_0 = $(this.st.el).parents("li.menu-item");
						do{
							_parent_0 = $(_parent_0).prev("li.menu-item");
						}while( !$(_parent_0).hasClass("menu-item-depth-0") );
						_t_cur_json = JSON.parse($("#edit-menu-item-grankare-" + $(_parent_0).find(".grankare-general-settings-form").data("menu")).val());
						if( _t_cur_json.megamenu === 1 ) $("#grankare-general-settings-form").addClass("megamenu-actived");
					}

					$("select.grankare-menu-icons").on("change", function(){
						_cur_json.icon = $(this).val();
						$(_cur_menu).val(JSON.stringify(_cur_json));
					});

					$("input.grankare-megamenu-option").on("click", function(){
						_cur_json.megamenu = $(this).prop("checked") ? 1 : 0;
						$(_cur_menu).val(JSON.stringify(_cur_json));
					});

					$("select.grankare-megamenu-col").on("change", function(){
						_cur_json.megamenucol = $(this).val();
						$(_cur_menu).val(JSON.stringify(_cur_json));
					});

					$("select.grankare-megamenu-widget").on("change", function(){
						_cur_json.megamenuwidget = $(this).val();
						$(_cur_menu).val(JSON.stringify(_cur_json));
					});
				}
			}
		});

		var _menu_icons = grankare_object.icons;
		$.each(_menu_icons, function( index, value ) {
			let _icon_code = value[2].replace( "\\", "&#x" );
			$(".grankare-menu-icons").append( '<option value="'+ value[1] +'">'+ value[1].replace('ti-','') + ' - '+ _icon_code +';</option>' );
		});
	});
	
})( jQuery );