<?php

// Woocommerce
Grankare_Options::grankare_set_section( array(
	'title'      => esc_html__( 'Woocommerce', 'grankare-addon' ),
	'id'         => 'woocommerce-tab'
) );

Grankare_Options::grankare_set_sub_section( array(
	'title'      => esc_html__( 'Shop', 'grankare-addon' ),
	'id'         => 'shop-tab',
	'fields'	 => array(
		array(
			'id'			=> 'shop-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Shop Page Title Settings', 'grankare-addon' ),
			'description'	=> esc_html__( 'This is settings for shop page title.', 'grankare-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'shop-title',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disabe Shop Page Title', 'grankare-addon' ),
			'description'	=> esc_html__( 'Enable or disable shop page title section', 'grankare-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'shop-title-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Shop Page Title Elements', 'grankare-addon' ),
			'description'	=> esc_html__( 'These are shop page title elements. Drag which items you want to display left, center and right part.', 'grankare-addon' ),
			'default'		=> array(
				'left' => array(
				),
				'center' => array(
					'title' => esc_html__( 'Title', 'grankare-addon' ),
					'breadcrumb' => esc_html__( 'Breadcrumb', 'grankare-addon' )
				),
				'right' => array(
				),
				'disabled' => array(
					'description' => esc_html__( 'Description', 'grankare-addon' )
				)
			),
			'required'		=> array( 'shop-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'shop-title-color',
			'type'			=> 'color',
			'title'			=> esc_html__( 'Shop Page Title Color', 'grankare-addon' ),
			'description'	=> esc_html__( 'This is color settings of shop page title.', 'grankare-addon' ),
			'required'		=> array( 'shop-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'shop-title-desc-color',
			'type'			=> 'color',
			'title'			=> esc_html__( 'Shop Page Title Description Color', 'grankare-addon' ),
			'description'	=> esc_html__( 'This is color settings of shop page description.', 'grankare-addon' ),
			'required'		=> array( 'shop-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'shop-title-link-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Shop Page Title Link Color', 'grankare-addon' ),
			'description'	=> esc_html__( 'This is link color setting for shop page title links. Like breadcrumbs color.', 'grankare-addon' ),
			'default'		=> '',
			'required'		=> array( 'shop-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'shop-title-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Shop Page Title Padding', 'grankare-addon' ),
			'description'	=> esc_html__( 'This is padding for shop page title. Example 10 for all side', 'grankare-addon' ),
			'default'		=> '',
			'required'		=> array( 'shop-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'shop-title-bg',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Shop Page Title Background', 'grankare-addon' ),
			'description'	=> esc_html__( 'This is background settings of page title.', 'grankare-addon' ),
			'required'		=> array( 'shop-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'shop-pl-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Shop Page Layout Settings', 'grankare-addon' ),
			'description'	=> esc_html__( 'This is settings for shop page layout.', 'grankare-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'shop-sidebar-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Shop Single Post Sidebar Layout', 'grankare-addon' ),
			'description'	=> esc_html__( 'Choose shop page sidebar layout.', 'grankare-addon' ),
			'items'		=> array(
				'right-sidebar' => array(
					'title' => esc_html__( 'Right Sidebar', 'grankare-addon' ),
					'url' => GRANKARE_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
				),
				'left-sidebar' => array(
					'title' => esc_html__( 'Left Sidebar', 'grankare-addon' ),
					'url' => GRANKARE_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
				),
				'both-sidebar' => array(
					'title' => esc_html__( 'Both Sidebar', 'grankare-addon' ),
					'url' => GRANKARE_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
				),
				'no-sidebar' => array(
					'title' => esc_html__( 'No Sidebar', 'grankare-addon' ),
					'url' => GRANKARE_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
				)
			),
			'default' => 'right-sidebar'
		),
		array(
			'id'			=> 'shop-right-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Shop Page Right Widgets Area', 'grankare-addon' ),
			'description'	=> esc_html__( 'Choose widget for shop page right widget area', 'grankare-addon' ),
			'default'		=> '',
			'required'		=> array( 'shop-sidebar-layout', '=', array( 'right-sidebar', 'both-sidebar' ) )
		),
		array(
			'id'			=> 'shop-left-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Shop Page Left Widgets Area', 'grankare-addon' ),
			'description'	=> esc_html__( 'Choose widget for shop page left widget area', 'grankare-addon' ),
			'default'		=> '',
			'required'		=> array( 'shop-sidebar-layout', '=', array( 'left-sidebar', 'both-sidebar' ) )
		)
	)
) );

Grankare_Options::grankare_set_sub_section( array(
	'title'      => esc_html__( 'Product', 'grankare-addon' ),
	'id'         => 'product-tab',
	'fields'	 => array(
		array(
			'id'			=> 'product-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Product Page Title Settings', 'grankare-addon' ),
			'description'	=> esc_html__( 'This is settings for product page title.', 'grankare-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'product-title',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disabe Product Page Title', 'grankare-addon' ),
			'description'	=> esc_html__( 'Enable or disable product page title section', 'grankare-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'product-title-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Product Page Title Elements', 'grankare-addon' ),
			'description'	=> esc_html__( 'These are product page title elements. Drag which items you want to display left, center and right part.', 'grankare-addon' ),
			'default'		=> array(
				'left' => array(
				),
				'center' => array(
					'title' => esc_html__( 'Title', 'grankare-addon' ),
					'breadcrumb' => esc_html__( 'Breadcrumb', 'grankare-addon' )
				),
				'right' => array(
				),
				'disabled' => array(
					'description' => esc_html__( 'Description', 'grankare-addon' )
				)
			),
			'required'		=> array( 'product-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'product-title-color',
			'type'			=> 'color',
			'title'			=> esc_html__( 'Product Page Title Color', 'grankare-addon' ),
			'description'	=> esc_html__( 'This is color settings of product page title.', 'grankare-addon' ),
			'required'		=> array( 'product-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'product-title-desc-color',
			'type'			=> 'color',
			'title'			=> esc_html__( 'Product Page Title Description Color', 'grankare-addon' ),
			'description'	=> esc_html__( 'This is color settings of product page description.', 'grankare-addon' ),
			'required'		=> array( 'product-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'product-title-link-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Product Page Title Link Color', 'grankare-addon' ),
			'description'	=> esc_html__( 'This is link color setting for product page title links. Like breadcrumbs color.', 'grankare-addon' ),
			'default'		=> '',
			'required'		=> array( 'product-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'product-title-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Product Page Title Padding', 'grankare-addon' ),
			'description'	=> esc_html__( 'This is padding for product page title. Example 10 for all side', 'grankare-addon' ),
			'default'		=> '',
			'required'		=> array( 'product-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'product-title-bg',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Product Page Title Background', 'grankare-addon' ),
			'description'	=> esc_html__( 'This is background settings of page title.', 'grankare-addon' ),
			'required'		=> array( 'product-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'product-pl-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Product Page Layout Settings', 'grankare-addon' ),
			'description'	=> esc_html__( 'This is settings for product page layout.', 'grankare-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'product-sidebar-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Product Single Post Sidebar Layout', 'grankare-addon' ),
			'description'	=> esc_html__( 'Choose product page sidebar layout.', 'grankare-addon' ),
			'items'		=> array(
				'right-sidebar' => array(
					'title' => esc_html__( 'Right Sidebar', 'grankare-addon' ),
					'url' => GRANKARE_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
				),
				'left-sidebar' => array(
					'title' => esc_html__( 'Left Sidebar', 'grankare-addon' ),
					'url' => GRANKARE_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
				),
				'both-sidebar' => array(
					'title' => esc_html__( 'Both Sidebar', 'grankare-addon' ),
					'url' => GRANKARE_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
				),
				'no-sidebar' => array(
					'title' => esc_html__( 'No Sidebar', 'grankare-addon' ),
					'url' => GRANKARE_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
				)
			),
			'default' => 'right-sidebar'
		),
		array(
			'id'			=> 'product-right-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Product Page Right Widgets Area', 'grankare-addon' ),
			'description'	=> esc_html__( 'Choose widget for product page right widget area', 'grankare-addon' ),
			'default'		=> '',
			'required'		=> array( 'product-sidebar-layout', '=', array( 'right-sidebar', 'both-sidebar' ) )
		),
		array(
			'id'			=> 'product-left-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Product Page Left Widgets Area', 'grankare-addon' ),
			'description'	=> esc_html__( 'Choose widget for product page left widget area', 'grankare-addon' ),
			'default'		=> '',
			'required'		=> array( 'product-sidebar-layout', '=', array( 'left-sidebar', 'both-sidebar' ) )
		)
	)
) );

Grankare_Options::grankare_set_end_section( array(
	'id'		=> 'woocommerce-end'	
));