<?php
/**
 * Header file for the Grankare WordPress theme.
 */

?><!DOCTYPE html>

<html class="no-js" <?php language_attributes(); ?>>

	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1.0" >
		<link rel="profile" href="https://gmpg.org/xfn/11">
		<?php wp_head(); ?>
	</head>

	<body <?php body_class(); ?>>

		<?php wp_body_open(); // For wp wp_body_open action hook ?>

		<?php
			/*
			* Set grankare page meta
			*/
			if( is_singular() ){
				Grankare_Wp_Elements::$grankare_page_options = get_post_meta( get_the_ID(), 'grankare_post_meta', true );
			}
			$keys = array(
				'chk' => 'general-chk',
				'fields' => array(
					'site_layout' => 'site-layout'
				)			
			);
			$layout = Grankare_Wp_Elements::grankare_get_meta_and_option_values( $keys );
			$pageloader_opt = Grankare_Wp_Elements::grankare_options('page-loader-option');
		?>

		<div class="grankare-body-inner<?php if( $layout['site_layout'] == 'boxed' ) echo esc_attr( ' container' ); ?>">
		
			<?php if( $pageloader_opt == '1' ) : ?>
			<div class="page-loader"><span class="page-loader-divider"></span></div>
			<?php endif; ?>	

			<?php
			/*
			 * Grankare Header Before Action 
			 * 10 - grankare_mobile_header
			 */
			do_action( 'grankare_header_before' );
			?>
			
			<?php
			/*
			 * Grankare Header Action 
			 * 10 - grankare_desktop_header
			 */
			do_action( 'grankare_header' );
			?>
			
			<?php
			/*
			 * Grankare Header After Action 
			 * 10 - grankare_header_slider
			 */
			do_action( 'grankare_header_after' );
			?>